/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.phys;

public class AABB {
    private float epsilon = 0.0f;
    public float x0;
    public float y0;
    public float z0;
    public float x1;
    public float y1;
    public float z1;

    public AABB(float x0, float y0, float z0, float x1, float y1, float z1) {
        this.x0 = x0;
        this.y0 = y0;
        this.z0 = z0;
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
    }

    public AABB expand(float xa, float ya, float za) {
        float _x0 = this.x0;
        float _y0 = this.y0;
        float _z0 = this.z0;
        float _x1 = this.x1;
        float _y1 = this.y1;
        float _z1 = this.z1;
        if (xa < 0.0f) {
            _x0 += xa;
        }
        if (xa > 0.0f) {
            _x1 += xa;
        }
        if (ya < 0.0f) {
            _y0 += ya;
        }
        if (ya > 0.0f) {
            _y1 += ya;
        }
        if (za < 0.0f) {
            _z0 += za;
        }
        if (za > 0.0f) {
            _z1 += za;
        }
        return new AABB(_x0, _y0, _z0, _x1, _y1, _z1);
    }

    public AABB grow(float xa, float ya, float za) {
        float _x0 = this.x0 - xa;
        float _y0 = this.y0 - ya;
        float _z0 = this.z0 - za;
        float _x1 = this.x1 + xa;
        float _y1 = this.y1 + ya;
        float _z1 = this.z1 + za;
        return new AABB(_x0, _y0, _z0, _x1, _y1, _z1);
    }

    public float clipXCollide(AABB c2, float xa) {
        if (c2.y1 > this.y0 && c2.y0 < this.y1) {
            if (c2.z1 > this.z0 && c2.z0 < this.z1) {
                float max;
                if (xa > 0.0f && c2.x1 <= this.x0 && (max = this.x0 - c2.x1 - this.epsilon) < xa) {
                    xa = max;
                }
                if (xa < 0.0f && c2.x0 >= this.x1 && (max = this.x1 - c2.x0 + this.epsilon) > xa) {
                    xa = max;
                }
                return xa;
            }
            return xa;
        }
        return xa;
    }

    public float clipYCollide(AABB c2, float ya) {
        if (c2.x1 > this.x0 && c2.x0 < this.x1) {
            if (c2.z1 > this.z0 && c2.z0 < this.z1) {
                float max;
                if (ya > 0.0f && c2.y1 <= this.y0 && (max = this.y0 - c2.y1 - this.epsilon) < ya) {
                    ya = max;
                }
                if (ya < 0.0f && c2.y0 >= this.y1 && (max = this.y1 - c2.y0 + this.epsilon) > ya) {
                    ya = max;
                }
                return ya;
            }
            return ya;
        }
        return ya;
    }

    public float clipZCollide(AABB c2, float za) {
        if (c2.x1 > this.x0 && c2.x0 < this.x1) {
            if (c2.y1 > this.y0 && c2.y0 < this.y1) {
                float max;
                if (za > 0.0f && c2.z1 <= this.z0 && (max = this.z0 - c2.z1 - this.epsilon) < za) {
                    za = max;
                }
                if (za < 0.0f && c2.z0 >= this.z1 && (max = this.z1 - c2.z0 + this.epsilon) > za) {
                    za = max;
                }
                return za;
            }
            return za;
        }
        return za;
    }

    public boolean intersects(AABB c2) {
        return c2.x1 > this.x0 && c2.x0 < this.x1 ? (c2.y1 > this.y0 && c2.y0 < this.y1 ? c2.z1 > this.z0 && c2.z0 < this.z1 : false) : false;
    }

    public void move(float xa, float ya, float za) {
        this.x0 += xa;
        this.y0 += ya;
        this.z0 += za;
        this.x1 += xa;
        this.y1 += ya;
        this.z1 += za;
    }
}

